from django.db import models
# -*- coding: iso-8859-2 -*-
# Create your models here.


class Predavac(models.Model):
    meno = models.CharField(max_length=30)
    def __unicode__(self):
        return u"%s" % (self.meno)
    class Meta:
        verbose_name=u"Predavac"
        verbose_name_plural=u"Predavaci"

class Kategoria(models.Model):
    nazov = models.CharField(max_length=30)
    def __unicode__(self):
        return u"%s" % (self.nazov)
    class Meta:
        verbose_name=u"Kategoria"
        verbose_name_plural=u"Kategorie"

class Tovar(models.Model):
    nazov = models.CharField(max_length=30)
    cena = models.IntegerField()
    kolko_na_sklade = models.IntegerField()
    kategoria = models.ForeignKey(Kategoria)
    def __unicode__(self):
        return u"%s - %d" % (self.nazov,self.kolko_na_sklade)
    class Meta:
        verbose_name=u"Tovar"
        verbose_name_plural=u"Tovary"


    
class Kupujuci(models.Model):
    meno = models.CharField(max_length=30)
    adresa = models.CharField(max_length=30)
    nick = models.CharField(max_length=30)
    heslo = models.CharField(max_length=30)
    def __unicode__(self):
        return u"%s" % self.meno
    class Meta:
        verbose_name=u"Kupujuci"
        verbose_name_plural=u"Kupujuci"

    
class Objednavka(models.Model):
    kupujuci = models.ForeignKey(Kupujuci)
    vybavena = models.BooleanField()
    predavac = models.ForeignKey(Predavac,null=True)
    def __unicode__(self):
        return u"objednavka kupujuceho: %s" % self.kupujuci
    class Meta:
        verbose_name=u"Objednavka"
        verbose_name_plural=u"Objednavky"

    
class Polozka(models.Model):
    tovar = models.ForeignKey(Tovar)
    kolko = models.IntegerField()
    objednavka = models.ForeignKey(Objednavka)
    def __unicode__(self):
        return u"tovar: %s , kusov %d" %(self.tovar,self.kolko)
    class Meta:
        verbose_name=u"Polozka"
        verbose_name_plural=u"Polozky"

