function stuptvardemo(A, tol)
% STUPTVARDEMO  Stupnovity tvar - dynamicke demo
% Ide len o (slovensku) modifikaciu znamej "RREFMOVIE"
% Na rozdiel od RREFMOVIE ide o stupnovity tvar matice
% stuptvardemo(A, tol)
% stuptvardemo(A, tol)  dava stupnovity tvar matice A.
% Ak nezadate maticu, demo pracuje s default-maticou A, ktora
% je tu (hned ponize) definovana (ma rozmer [8 6] a hodnost 4)
% Algoritmus preskakuje stlpec, v ktorom  abs(pivot)< tol.
%
if nargin < 1
    A = [ 9     4     1     6    12     7
          4     0     4    15     1    14
          7     0     7     8    10     9
         16     0    16     3    13     2
          0     2    -4     0     0     0
          0     6   -12     0     0     0
          9     0     9     6    12     7
          5     0     5    10     8    11];
end
format, format compact, clc
disp('Toto demo je modifikaciou RREFMOVIE, ktore je demo pre RREF')
disp('Demo prezentuje dynamiku riadkovych ekviv.uprav, ktore vedu')
disp('na STUPNOVITY tvar danej matice rozmeru [m, n].')
disp('Algoritmus eliminacie uplatnuje pivotovanie (v stlpci)')
disp('-----------------------------------------------------------')
disp('Vstupna matica:')
A
disp('pouzivame zname: press any key to continue..;-)')
disp(' '), pause
[m,n] = size(A);
vp = [];  % vp zbiera indexy volnych premennych.....

if (nargin < 2), tol = max([m,n])*eps*norm(A,'inf'); end

i = 1; j = 1;
while (i <= m) & (j <= n)
   [p, k] = max(abs( A(i:m,j) )); k = k+i-1;
   if (p <= tol)
      vp = [vp j];
      if j~= n
         disp(['preskakujeme stlpec ' int2str(j) ' lebo nema pivota'])
      else
         disp('Eliminacia ukoncena!')
      end %if
      A(i:m,j) = zeros(m-i+1,1);
      disp(' '), pause
      j = j + 1;
   else
      if i ~= k
         % Swap i-th and k-th rows.
         disp(['nasleduje vymena riadkov: ' int2str(i) ' a ' int2str(k) ])
         disp(' '), pause
         A([i k], j:n) = A([k i], j:n), disp(' '), pause
      end
      disp(['pivot = A(' int2str(i) ',' int2str(j) ') eliminuje stlpec ' int2str(j)])
	  disp(' '), pause
      for r = i+1:m
         A(r,j:n) = A(r,j:n) - (A(r,j)/A(i,j))*A(i,j:n);
      end
      A   
      disp(' ')
      i = i + 1; 
      j = j + 1;
   end %if
end
vp = [vp j:n];
disp('-------------------------------------------------------');
disp('Stupnovity tvar vstupnej matice A  predstavuje matica U');
disp(' ')
U = A, disp(' '), pause
disp('Vymenujte indexy stlpcov, ktore odpovedaju "volnym" premennym!');
disp(' '), pause
disp('Indexy volnych premennych su:');
vp, disp(' '), pause
disp('Zrejme vzdy plati: null(A) = null(U). Urcte dimenziu null(A)!'); 
disp(' '), pause
disp(['Dimenzia null(A) = ' int2str(length(vp)) '   uvedomujete si ... preco?!']);
disp(' '), pause
disp('Viete akou volbou volnych premennych ziskame bazu null(A)?')
disp(' '), pause
disp('Vdaka baze nuloveho priestoru vieme popisat vseobecne riesenie!')
disp(' '), pause
disp('END funkcie StupTvarDemo (ziskavania stupnoviteho tvaru matice A)')



