function [A, jpiv] = stuptvar(A, tol)
% STUPTVAR    stupnovity tvar matice A (rozmer A = [m n])
% [A, jpiv] = stuptvar(A, tol)
%
% STUPTVAR  je output procesu eliminacie (s pivotovanim v stlpci)
% jpiv      je vektor indexov bazovych stlpcov
%
% ak  max(abs(A(i:m, j)))<= tol, 
%     tak prvky stlpca <j> sa od miesta (i,j)-vcitane! vynuluju
% ak  nargin = 1,  tak tol = max(m,n)*eps*normA (to je standard) 

[m, n] = size(A);
if (nargin < 2), tol = max(m,n)*eps*norm(A,'inf'); end

i = 1;
j = 1;
jpiv = [];
while (i <= m)&(j <= n)
   [piv, k] = max( abs( A(i:m,j) )); k = k+i-1;
   if (piv <= tol)
      A(i:m,j) = zeros(m-i+1,1);
      j = j+1;
   else
      jpiv = [jpiv j];
      A([i k], j:n) = A([k i], j:n);
      for k = i+1:m
         A(k,j:n) = A(k,j:n) - (A(k,j)/A(i,j))*A(i,j:n);
      end
      i = i+1;
      j = j+1;
   end
end
   