function A = intmat(m,n,a,b)
% INTMAT   generuje maticu [m,n], A(i,j) su RAND-INTEGERS z [ a, b]
% A = intmat(m,n,a,b)
%
% INTMAT(m)   generuje maticu [m,m], A(i,j) su RAND&INT z [-9, 9]
% INTMAT(m,n)   generuje maticu [m,n], A(i,j) su RAND&INT z [-9, 9]
% INTMAT(m,n,a)   generuje maticu [m,n], A(i,j) su RAND&INT z [-a, a]
% INTMAT(m,n,a,b) generuje maticu [m,n], A(i,j) su RAND&INT z [ a, b], pricom a ~= b
%
if nargin == 1,
   A = round(18*rand(m,m)-9); 
elseif nargin < 3
   A = round(18*rand(m,n)-9); 
elseif nargin < 4
   A = round(2*a*rand(m,n) - a); 
elseif a == b
   disp('chybny vstup, interval ma nulovu dlzku')
   return
elseif a > b
   t = a; a = b; b = t;
   A = round((b - a)*rand(m,n) + a);
else
   A = round((b - a)*rand(m,n) + a);
end

