clc, echo on
% Toto je script  "demo_VR.m"  (=demo Vseobecneho Riesenia)
% demo ilustruje, ako ziskat vseobecne riesenie ulohy
%
%                     A.x = b
%
% v pripade stvorcovej, singularnej matice A. Pozri skripta
% strany 53, 54 (teraz budeme pracovat s va:csou maticou)
% ---------------------------------------------------------
% pre script plati zname:   "press any key to continue..."
% ---------------------------------------------------------
pause
echo off
clc, warning off
format rat, format compact 
disp('V tomto scripte chceme uvazovat singularnu maticu A.')
disp('Pripomenme si maticu A, zo scriptu "demo_EP", ktorej')
disp('hodnost sa rovna 4:')
A = [  2     3    -2      0      
       4     7    -4      2      
      -4    -6     1      1      
       4     3     1     -8]
disp(' ')
disp('modifikujme ju, aby sme ziskali singularnu maticu hodnosti 2')
pause
disp(' ')
disp('pouzijeme priradenie: A(:, 2) = 2*A(:, 1), ktore zaruci, ze')
disp('druhy stlpec A bude dvojnasobkom prveho stlpca')
disp(' ')
pause
disp('A(:, 2)= 2*A(:, 1)')
A(:, 2) = 2*A(:, 1)
disp(' ')
disp('Overme, ze hod(A) = 3')
disp(' ')
pause
disp('rank(A)')
rank(A)
disp('OK!')
disp('Teraz pouzime priradenie A(:, 4) = A(:, 1) + A(:, 2) - A(:, 3)')
disp('ktore zaruci, ze 4.stlpec A  bude linearnou kombinaciou prvych')
disp('troch stlpcov A.')
disp(' ')
pause
disp('A(:, 4) = A(:, 1) + A(:, 2) - A(:, 3)')
A(:, 4) = A(:, 1) + A(:, 2) - A(:, 3)
disp(' ')
disp('rank(A)')
rank(A)
disp(' ')
pause
disp('Matica  A  ma teraz hodnost 2. Ukazeme, ze eliminacny proces')
disp('skonci maticou stupnovitou a  odpovedajuca sustava bude mat')
disp('volne premenne.')
disp(' ')
disp('Nasleduje eliminacny proces (teraz - na rozdiel od "demo_EP"')
disp('bez komentara)')
pause

A11 = vymr(A, 1, 2)
pause

A21 = nrpr(A11, -1/2, 1, 2)
pause

A31 = nrpr(A21, 1, 1, 3 )
pause

A41 = nrpr(A31, -1, 1, 4 )
pause

A1 = A41
disp(' ')
disp('Toto je matica A1  prvej redukovanej sustavy.')
disp('Ako vidime, prejdeme hned do tretieho stlpca!')
disp(' ')
disp('Zacneme vymenou 2. a 4. riadku:')
pause

A23 = vymr(A1, 2, 4)
pause

A33 = nrpr(A23, 3/5, 2, 3)
pause

disp(' ')
disp('matica A33 ma  STUPNOVITU  formu, pricom vidime, ze')
disp('volnymi premennymi su: x2, x4.')
disp(' ')
disp('Uvedomme si, ze je mozne ich volit lubovolne(!)')
disp('a kazda volba indukuje nejake riesenie.')
pause
disp(' ')
disp('Otazka:')
disp('Ako v  MATLABe  predstavit "vseobecnene riesenie" ?')
pause
disp(' ')
disp('M-funkcia "null(A)" nam poskytne bazu nuloveho priestoru:')
format, format compact
disp(' ')
disp('mu = null(A)')
mu = null(A)
pause
disp(' ')
disp('Tentoraz chceme naozaj pocitat, a preto zvolme vektor b')
disp('pre pravu stranu sustavy.')
disp('Nech napr. b = [1;1;1;1], co dosiahneme v ML jednoducho')
disp('prikazom  b = ones(4,1)')
pause
disp(' ')
disp('b = ones(4, 1)')
b = ones(4, 1)
pause
disp(' ')
disp('riesenie A.x = b dava prikaz "x = A\b", alebo "pinv(A)*b"') 
disp('skusme "A\b" ')
pause
disp(' ')
disp('xp = A\b')
xp = A\b
disp('riesenie sme nedostali.....')
pause
disp(' ')
disp('Skusme prikaz: "pinv(A)*b" ')
pause
disp(' ')
disp('xp = pinv(A)*b')
xp = pinv(A)*b
disp(' ')
disp('Presvedcme sa, ze xp  je "partikularne" riesenie, teda,')
disp('ze plati:  A*xp = b ')
pause
disp(' ')
disp('Editujme prikaz: "A*xp - b" (ocakavame nulovy vektor)')
disp(' ')
disp('A*xp - b')
A*xp - b
pause
disp(' ')
disp('MATLAB nedava "klasicke" riesenie, pretoze neexistuje!')
disp('Keby existovalo, dal by ho  (tak je to v ML zariadene)')
disp(' ')
disp('Mimochodom, to sme mohli zistit hned na zaciatku takto:')
pause
disp(' ')
disp('Ukazme, ze zvoleny vektor  b = [1; 1; 1; 1]  nelezi v ') 
disp('priestore stlpcov matice A, lebo  hod(A) < hod([A b])')
disp('volajme prikaz rank(A), resp. rank([A b])')
pause
disp('hodA = rank(A)')
hodA = rank(A)
pause
disp('hodAb = rank([A  b])')
hodAb = rank([A  b])
pause
disp(' ')
disp('Ak mame hovorit (zatial) o klasickom! rieseni, MUSIME ')
disp('zmenit vektor b tak, aby klasicke riesenie existovalo.')
pause
disp(' ')
disp('Podme na to "odzadu". Berme x = [1; 2; 3; 4] a vektor b')
disp('ziskajme ako sucin  A*x. Takto "dopredu" si zaistime ')
disp('riesitelnost ulohy  A*x = b.') 
disp(' ')
disp('Nech  xu = [1; 2; 3; 4]; b = A*xu')
pause
xu = [1; 2; 3; 4], b = A*xu
pause
clc
disp('Zhrnme:')
disp('Mame  A  a vieme, ze je singularna, jej hodnost = 2.')
disp('Vieme, ze uloha:')
disp(' ')
disp('               A*x = [36; 72; -69; 67]')
disp(' ')
disp('ma riesenie')
disp('vieme dokonca, ze uloha ma nekonecne vela rieseni')
disp('a chceme ziskat jej "vseobecne" riesenie.')
pause
disp(' ')
disp('Ako sme uz povedali, ak uloha: A.x = b  ma "klasicke"')
disp('riesenie, tak v ML ho ziskame')
disp('prikazom:')
disp('                        A\b ')
disp('alebo prikazom ')
disp('                      pinv(A)*b ')
pause
disp(' ')
disp('Skusme "xp = A\b" ')
disp(' ')
pause
disp('xp = A\b')
xp = A\b
disp(' ')
disp('Vidime, ze riesenie sme neziskali. Skusme "pinv(A)*b" ')
pause
disp(' ')
disp('xp = pinv(A)*b ')
xp = pinv(A)*b
pause
disp(' ')
disp('Overme, ze  xp  je partikularne riesenie ulohy. Zistime')
disp('comu sa rovna rezidualny vektor: rez = A*xp - b')
disp(' ')
pause
disp('rez = A*xp - p')
rez = A*xp - b
disp(' ')
disp('OK! Rezidualny vektor sa (prakticky) rovna nulovemu vektoru')
pause
disp('-----------------------------------------------------------')
disp(' ')
disp('A nakoniec vseobecne riesenie:')
disp(' ')
disp('                     xvs = xp + mu*[alfa; beta]')
disp(' ')
disp('kde stlpec  [alfa; beta]  je stlpec lubovolnych koeficientov.')
disp(' ')
disp('Napriklad, nech  alfa = 2.5;  beta = -0.7')
pause
alfa = 2.5;  beta = -0.7;
disp(' ')
disp('Vseobecne riesenie ma tvar:   xvs = xp + mu*[alfa; beta]')
disp(' ')
disp('xvs = xp + mu*[alfa; beta] ')
xvs = xp + mu*[alfa; beta]
pause
disp(' ')
disp('Overme! Zistujme zlozky vektora:  rez = A*xvs - b')
disp(' ')
disp('rez = A*xvs - b')
pause
rez = A*xvs - b
disp(' ')
disp('Vidime, ze zlozky vektora "rez" su prakticky nulove, co')
disp('znamena, ze vsetko sedi.')
disp('END of "demo_VR"')

 