clc, echo on
%                                                                  %
%     Toto je  script  "demo_EP.m" = demo Eliminacneho Procesu     %
%     (s pivotovanim)                                              %
%                                                                  %
%     Demo ilustruje, ako eliminacnym procesom v pripade, ze A     % 
%     je regularna, prejdeme od matice A  ---->  ku matici U,      %                     %
%                                                                  %
%     kde U je horna trojuholnikova matica, ktorej vsetky          %
%     diagonalne prvky  U(i,i) su nenulove.                        %
%                                                                  %
%     Pivotovanie zarucuje, ze proces je numericky stabilny.       %
%                                                                  %
% ------------------------------------------------------------------
%     pre script plati to zname:   "press any key to continue ..." %
% ------------------------------------------------------------------
pause
echo off
clc
disp('***   Eliminacny Proces (s pivotovanim), ak  A  je regularna   ***')
disp('***   pozri skripa, str. 173                                   ***')
disp('------------------------------------------------------------------')
disp('Predpokladame, ze ste oboznameni s vyznamom a syntaxou m-funkcii: ')
disp(' ')
disp('"vymr" :  vymr(A,i,j)    vymena riadkov v matici A                ')
disp('"nrpr" :  nrpr(A,c,i,j)  c-nasobok riadku i pripocitame k riadku j')
disp(' ')
disp('ak nie, prikaz Ctrl+C zastavi tento script a pouzite "help (+fun)"')
disp('samozrejme, funkcie "vymr", "nrpr" sa musia nachadzat v adresari, ')
disp('kde sa ML vie dostat, napr. v tom, kde mate tento script "demo_EP"') 
pause
clc
disp('Nech matica A  ma rozmer  [4, 4]:')

format rat, format compact

 A = [ 2     3    -2      0      
       4     7    -4      2      
      -4    -6     1      1      
       4     3     1     -8]
disp(' ')
disp('Presvedcme sa, ze hodnost(A) = 4 (=rozmer A); volajme:')
disp('rank(A)')
rank(A)
pause

disp(' ')
disp('hod(A)= 4, t.j. hod(A)= n, a preto  A je regularna.')
disp(' ')
disp('Aplikujme eliminacny proces s pivotovanim v stlpci:')
disp(' ')
disp('Zaciname urcenim  pivota pre elimaciu v prvom stlpci A ')
disp('Vidime, ze je treba vymenit prvy riadok napr. s druhym')
disp('a to dosiahneme funkciou "vymr": A11 =  vymr(A, 1, 2)')
disp(' ')
pause
disp('A11 = vymr(A, 1, 2)')
A11 = vymr(A, 1, 2)
disp(' ')
disp('nasledujuce matice budeme oznacovat ako Ai1, pre i = 2,3,4')
disp('pretoze index i je riadkovy index, kym index j')
disp('stlpcovy =1, lebo "pracovny" stlpec sa rovna 1')
pause

disp(' ')
disp('A21 = nrpr(A11, -1/2, 1, 2) zariadi eliminovanie na mieste (2,1)')
pause
disp(' ')
disp('A21 = nrpr(A11, -1/2, 1, 2)')
A21 = nrpr(A11, -1/2, 1, 2)
disp(' ')
pause

disp('A31 = nrpr(A21, 1, 1, 3) zariadi eliminovanie na mieste (3,1)')
disp(' ')
pause
disp('A31 = nrpr(A21, 1, 1, 3)')
A31 = nrpr(A21, 1, 1, 3)
disp(' ')
pause

disp('A41 = nrpr(A31, -1, 1, 4) zariadi eliminovanie na mieste (4,1)')
disp(' ')
pause
disp('A41 = nrpr(A31, -1, 1, 4)')
A41 = nrpr(A31, -1, 1, 4)
disp(' ')
pause

disp('A41 je matica prvej "redukovanej" sustavy; oznacme ju: A1')
disp(' ')
pause
disp('A1 = A41')
A1 = A41
disp(' ')
disp('matica A1 je matica prvej redukovanej sustavy')
disp('------------------------------------------------------')
pause
disp('Postupime do druheho stlpca, preto matice oznacime Ai2')
disp('Zaciname urcenim riadiaceho riadku, vyhladame pivota! ')
disp('Vidime, ze je treba vymenit druhy riadok so stvrtym,  ')
disp('co dosiahneme prikazom A22 = vymr(A1, 2, 4)')
disp(' ')
pause
disp('A22 = vymr(A1, 2, 4)')
A22 = vymr(A1, 2, 4)
disp(' ')
pause
disp('A32 = nrpr(A22, 1/4, 2, 3) zariadi eliminovanie na mieste (3,2)')
disp(' ')
pause
disp('A32 = nrpr(A22, 1/4, 2, 3)')
A32 = nrpr(A22, 1/4, 2, 3)
disp(' ')
pause
disp('A42 = nrpr(A32, -1/8, 2, 4) zariadi eliminovanie na mieste (4,2)')
disp(' ')
pause
disp('A42 = nrpr(A32, -1/8, 2, 4)')
A42 = nrpr(A32, -1/8, 2, 4)
disp(' ')
pause
disp('A42 je matica druhej "redukovanej" sustavy, oznacme ju A2')
disp(' ')
pause
disp('A2 = A42')
A2 = A42
disp(' ')
disp('matica A2 je matica druhej redukovanej sustavy')
disp('--------------------------------------------------------')
pause
disp('Dalsia praca sa tyka tretieho stlpca, matice oznacme Ai3')
disp('Tentoraz riadky vymienat nebudeme, pretoze 7/4 > 5/8')
disp('A43 = nrpr(A2, (5/8)/(-7/4), 3, 4)')
disp(' ')
pause
disp('A43 = nrpr(A2, (5/8)/(-7/4), 3, 4)')
A43 = nrpr(A2, (5/8)/(-7/4), 3, 4)
disp(' ')
pause
disp('A43 je horna trojuholnikova; oznacme ju U, nech U = A43')
disp(' ')
pause
disp('U = A43')
U = A43
disp(' ')
disp('Pretoze  U  je trojuholnikova, ktorej prvky diagonaly su')
disp('nenulove,')
disp('sustava  A.x = b  ma jedine riesenie pre akykolvek vektor')
disp('pravej strany.')
disp('Riesenie ziskame spa:tnou substituciou v sustave U.x = c,') 
disp('v ktorej vektor c  vznikne modifikovanim vektora b')
disp('v procese eliminacie.')
pause
disp(' ')
disp('Tu je koniec scriptu "demo_EP", ktory ilustruje eliminacny')
disp('proces pre pripad, ked matica  A je stvorcova a regularna.')
disp(' ')
disp('Zopakujme: ')
disp('Ak A je regularna, tak EP konci hornou trojuholnikovou')
disp('maticou U, ktorej vsetky diagonalne prvky su nenulove!')
disp(' ')
disp('END demo_EP.')
