function mx = newtonmv(mf,mfd,xs,tol)
% NEWTONmv  Newtonova metoda pre f(x) = 0, maticovy vystup
% mx = newtonmv(mf,mfd,xs,tol)
%
% argin : mf  = meno(retazec) funkcie f
%         mfd = meno derivacie f'
%         xs  = bod startu
%         tol = zastav. podmienka: |xn - xs| < tol
%
% argout: mx  = matica mx(:,1) = vektor aproximacii korena
%                      mx(:,2) = vektor f-hodnot v aproxim.
% --------------------------------------------------------
vx =[xs];
fs = feval(mf,xs);
fds= feval(mfd,xs);
disp(' ');

xn = xs - fs/fds;
vx = [vx; xn];
it = 1;

while abs(fs/fds)>= tol
   xs = xn;
   fs = feval(mf,xs);
   fds= feval(mfd,xs);
   xn = xs - fs/fds;
   it = it + 1;
   vx = [vx; xn];  
   if it > 20
      disp('s konvergenciou to nevyzera dobre ...')
      break
   end
end
mx = zeros(length(vx), 2);
mx(:,1)= vx;
mx(:,2)= feval(mf,vx);




