function xn = newton(mf,mfd,xs,tol)
% NEWTON -ova metoda na riesenie f(x)= 0, zakladna verzia.
% xn = newton(mf,mfd,xs,tol)
%
% argin : mf  = meno(retazec) funkcie f
%         mfd = meno derivacie f'
%         xs  = bod startu
%         tol = zastav. podmienka: |xn - xs| < tol
%
% argout: xn  = aproximacia korena
% ------------------------------------------------
fs = feval(mf,xs);
fds= feval(mfd,xs);

xn = xs - fs/fds;

while abs(xn - xs)>= tol
   xs = xn;
   fs = feval(mf,xs);
   fds= feval(mfd,xs);
   xn = xs - fs/fds;
end


