function x = bisekcia(mf,a,b,epsilon)
% BISEKCIA intervalu - riesenie rovnice f(x) = 0, zakladna verzia.
% x = bisekcia(mf,a,b,epsilon)
%
% argin : mf je meno(retazec) funkcie f(.) [lavej strany rovnice f(x) = 0]
%         a,b take, aby f(a).f(b) < 0  t.j. v (a, b) je znamienkova zmena
%
% argout: x = aproximacia korena "alfa", pricom  |x - alfa| < epsilon
% 
% *pozn.: ak vstupne "epsilon" je mensie ako eps*abs(b), tak cyklus while
%         sa moze stat "nekonecnym"! (Ctrl_C)
%
fa = feval(mf,a);
fb = feval(mf,b);
disp(' ');

if fa*fb >= 0
   disp('Chybny vstup! Pre vstupny interval neplati f(a)*f(b)< 0')
   return
end

if nargin < 4
   epsilon = eps*abs(b);
end

while b-a > epsilon
   x = (a+b)/2;
   fx = feval(mf,x);    
   if fx == 0
      disp(sprintf('pre x =%19.16f je f(x) = 0', x));
      return
   end
   if fa*fx < 0
      % koren lezi v (a, x)
      b  = x; 
      fb = fx;
   else
      % koren lezi v (x, b)
      a  = x; 
      fa = fx;
   end  
end
